﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Web;
using System.Web.UI.WebControls;
using VIRP_WEB.BaseCode;

namespace VIRP_WEB.Custom.EFR.DataExports
{
    public partial class Default : EfrBasePage
    {
        /// <summary>
        /// TODO: Move to DB?
        /// </summary>
        private static List<Tuple<string, string>> exports = new List<Tuple<string, string>>
        {
            //"BioInterpretation",
            new Tuple<string, string>("BioLab", "Bio Labs"),
            new Tuple<string, string>("BioQuestionnaire", "Bio Quesionnaires"),
            new Tuple<string, string>("ContactLog", "Contact Log"),
            new Tuple<string, string>("DoDFragment", "DoD Fragment Data"),
            new Tuple<string, string>("FollowUpReferral", "Follow-up Referrals"),
            new Tuple<string, string>("FragmentForm", "Fragment Forms"),
            new Tuple<string, string>("FragmentLab", "Fragment Labs"),
            new Tuple<string, string>("Imaging", "Patient Imaging"),
            new Tuple<string, string>("Patient", "Patients"),
            new Tuple<string, string>("Referral", "Referrals"),
            new Tuple<string, string>("RelatedDiagnoses", "Related Diagnoses"),
            new Tuple<string, string>("RelatedLabTests", "Related Lab Tests"),
            new Tuple<string, string>("VTAPatient", "VTA Data Extract")
        };

        protected override void Page_Load(object sender, EventArgs e)
        {
            ReplacePageTitle("My Tasks > Data Exports");

            if (!IsPostBack)
            {
                GetDsExports();
            }

            // Added for 508 compliance with GridView column headers and footer
            Page.ClientScript.RegisterStartupScript(GetType(), "UpdateGridView", "UpdateGridView('" + gridDataExports.ClientID + "');", true);
        }

        protected void GetDsExports()
        {
            DataSet dsExports = new DataSet();

            var exportsTable = dsExports.Tables.Add();

            exportsTable.Columns.Add("NAME");
            exportsTable.Columns.Add("DISPLAYNAME");

            foreach (var export in exports)
            {
                Tuple<string, string> t = export;

                var dr = exportsTable.Rows.Add();
                dr["Name"] = t.Item1;
                dr["DisplayName"] = t.Item2;
            }

            gridDataExports.DataSource = dsExports;
            gridDataExports.DataBind();
        }

        protected void LinkName_Click(object sender, EventArgs e)
        {
            const string ExtractUrl = "~/Custom/EFR/DataExports/DataExport{0}.aspx";

            ServiceInterfaceManager.LogInformation("POSTBACK_EVENT", string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);

            try
            {
                string commandArgument = ((System.Web.UI.WebControls.LinkButton)sender).CommandArgument;
                if (commandArgument.Length > 0)
                {
                    Response.Redirect(string.Format(ExtractUrl, commandArgument), false);
                }
            }
            catch (Exception ex)
            {
                ServiceInterfaceManager.LogError(ex.Message, string.Format("{0}.{1}", System.Reflection.MethodBase.GetCurrentMethod().DeclaringType.FullName, System.Reflection.MethodBase.GetCurrentMethod().Name), HttpContext.Current.User.Identity.Name, UserSession.CurrentRegistryId);
                throw ex;
            }
        }
    }
}